class MonsterArena2 extends TeamGamePlus config(UT4ever);//DeathMatchPlus

#exec AUDIO IMPORT FILE="Sounds\Extermination.WAV" NAME="Extermination" GROUP="Sounds"
#exec AUDIO IMPORT FILE="Sounds\NextWaveIn.WAV" NAME="NextWave" GROUP="Sounds"
#exec AUDIO IMPORT FILE="Sounds\One.WAV" NAME="One" GROUP="Sounds"
#exec AUDIO IMPORT FILE="Sounds\Two.WAV" NAME="Two" GROUP="Sounds"
#exec AUDIO IMPORT FILE="Sounds\Three.WAV" NAME="Three" GROUP="Sounds"

var()		 bool   bSpawnInTeamArea;
var()		 bool	bScoreTeamKills;
var() config bool	bNoTeamChanges;
var			 int	NumSupportingPlayer; 
var globalconfig	 bool	bBalanceTeams;	// bots balance teams
var globalconfig	 bool	bPlayersBalanceTeams;	// players balance teams
var			 bool	bBalancing;
var() config float  FriendlyFireScale; //scale friendly fire damage by this value
var() config int	MaxTeams; //Maximum number of teams allowed in (up to MaxAllowedTeams)
var			 int	MaxAllowedTeams;
var	TeamInfo Teams[4]; // Red, Blue, Green, Gold
var() config float  GoalTeamScore; //like fraglimit
var() config int	MaxTeamSize;
var  localized string StartUpTeamMessage, TeamChangeMessage,TeamPrefix;
var localized string TeamColor[4];

var		int			NextBotTeam;
var byte TEAM_Red, TEAM_Blue, TEAM_Green, TEAM_Gold;
var name CurrentOrders[4];
var int PlayerTeamNum;
var localized string StartupTeamTralier;

//Custom vars:
var bool bGameHasEnded, bWait;
var int WaitTime;

function PostBeginPlay()
{
	local int i;
	for (i=0;i<4;i++)
	{
		Teams[i] = Spawn(class'TeamInfo');
		Teams[i].Size = 0;
		Teams[i].Score = 0;
		Teams[i].TeamName = TeamColor[i];
		Teams[i].TeamIndex = i;
		TournamentGameReplicationInfo(GameReplicationInfo).Teams[i] = Teams[i];
	}
	
	Super.PostBeginPlay();

	GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave = 0;

	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'MA2_Mutator'));

	SetTimer(1.0,True);
}

function CheckPawns()
{
local Pawn P;
local int NumPlayers, NumMonsters;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('PlayerPawn') || P.IsA('Bot') )
			{
			NumPlayers++;
			}
		if ( P.IsA('ScriptedPawn') )
			{
			NumMonsters++;
			}
		}

	GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Monsters = NumMonsters;
	GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Players = NumPlayers;
}

function Timer()
{
local Pawn P;

	CheckPawns();
	if ( !bWait )
		CheckWaveEnd();
	else
		{
		WaitTime--;
		if ( WaitTime == 0 )
			{
			bWait = False;
			SpawnWaveMonsters();
			WaitTime = 7;
			}
		else if ( WaitTime == 5 )
			{
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('PlayerPawn') )
					{
					P.PlaySound(Sound'NextWave',,4.0);
					}
				}
			}
		else if ( WaitTime == 3 )
			{
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('PlayerPawn') )
					{
					P.PlaySound(Sound'Three',,4.0);
					}
				}
			}
		else if ( WaitTime == 2 )
			{
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('PlayerPawn') )
					{
					P.PlaySound(Sound'Two',,4.0);
					}
				}
			}
		else if ( WaitTime == 1 )
			{
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('PlayerPawn') )
					{
					P.PlaySound(Sound'One',,4.0);
					}
				}
			}
		}

	Super.Timer();
}

function CheckWaveEnd()
{
local Pawn P;

	if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Monsters == 0 )
		{
		if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && !bGameHasEnded )
			{
			log("GAME ENDED, NO MORE MONSTERS!!");
			EndGame("teamscorelimit");
			bGameHasEnded = True;
			}
		else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave < 10 && !bGameHasEnded )
			{
			GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave += 1;
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('PlayerPawn') && GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave != 1 )
					{
					P.ClientMessage("Round"@GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave-1$" Exterminated!", 'Pickup');
					P.PlaySound(Sound'Extermination',,4.0);
					}
				}
			bWait = True;
			}
		}
}

function SpawnWaveMonsters()
{
local SpawnActor SA;
local ScriptedPawn SP;
local bool bSpawn;

	ForEach AllActors(class'SpawnActor', SA)
		{
		bSpawn = False;
		//Find monstertype to spawn:
		if ( SA.IsA('Spawn_Pupae') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Pupae',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_ElitePupae') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'Monster_ElitePupae',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Brute') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.Brute',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_EliteBrute') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'Monster_EliteBrute',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Manta') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.Manta',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_CaveManta') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.CaveManta',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_DevilFish') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.DevilFish',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Fly') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.Fly',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_LesserBrute') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.LesserBrute',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjScout') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.SkaarjScout',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjWarrior') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.SkaarjWarrior',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Slith') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.Slith',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Tentacle') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealShare.Tentacle',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Gasbag') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Gasbag',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_GiantGasbag') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.GiantGasbag',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_GiantManta') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.GiantManta',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_IceSkaarj') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.IceSkaarj',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Krall') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Krall',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_KrallElite') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.KrallElite',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Mercenary') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Mercenary',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_MercenaryElite') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.MercenaryElite',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Queen') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Queen',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjAssassin') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjAssassin',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjBerserker') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjBerserker',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjGunner') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjGunner',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjInfantry') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjInfantry',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjLord') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjLord',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjOfficer') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjOfficer',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjSniper') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjSniper',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_SkaarjTrooper') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.SkaarjTrooper',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Squid') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Squid',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Titan') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.Titan',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_StoneTitan') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.StoneTitan',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_Warlord') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'UnrealI.WarLord',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_RazorWarlord') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'Monster_RazorWarLord',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_FlakWarlord') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'Monster_FlakWarLord',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		else if ( SA.IsA('Spawn_LavaSlith') )
			{
			if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 1 && SA.TriggerInWave01 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 2 && SA.TriggerInWave02 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 3 && SA.TriggerInWave03 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 4 && SA.TriggerInWave04 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 5 && SA.TriggerInWave05 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 6 && SA.TriggerInWave06 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 7 && SA.TriggerInWave07 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 8 && SA.TriggerInWave08 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 9 && SA.TriggerInWave09 )
				{
				bSpawn = True;
				}
			else if ( GRI_MA2(TournamentGameReplicationInfo(GameReplicationInfo)).Wave == 10 && SA.TriggerInWave10 )
				{
				bSpawn = True;
				}
			if ( bSpawn )
				{
				SP = Spawn(Class'Monster_LavaSlith',,,SA.Location);
				Spawn(Class'BotPack.UT_SpriteSmokePuff',,,SA.Location);
				SP.Health = SA.MonsterHealth;	
				SP.SetPhysics(PHYS_Falling);
				SP.bCollideWorld = true;
				}
			}
		}
}

defaultproperties
{
     bScoreTeamKills=True
     bBalanceTeams=True
     bPlayersBalanceTeams=True
     MaxTeams=2
     MaxAllowedTeams=4
     GoalTeamScore=30.000000
     MaxTeamSize=16
     StartUpTeamMessage="You are on"
     TeamChangeMessage=""
     TeamColor(0)="Hunters"
     TeamColor(1)="Monsters"
     TeamColor(2)="Monsters"
     TeamColor(3)="Monsters"
     TEAM_Blue=1
     TEAM_Green=2
     TEAM_Gold=3
     CurrentOrders(0)=Defend
     CurrentOrders(1)=Defend
     CurrentOrders(2)=Defend
     CurrentOrders(3)=Defend
     StartupTeamTralier="."
     NetWait=17
     StartUpMessage="Work with your teammates against the monsters."
     MaxCommanders=2
     bCanChangeSkin=False
     bTeamGame=True
     ScoreBoardType=Class'SB'
     RulesMenuType="UTMenu.UTTeamRSClient"
     SettingsMenuType="UTMenu.UTTeamSSClient"
     HUDType=Class'HUD_MA2'
     MapPrefix="MA2"
     //BeaconName="MH2"
     GameName="ut4ever.org Monster Arena 2"
     GameReplicationInfoClass=Class'GRI_MA2'
     WaitTime=7
     bWait=False
}
